CONTAINER fx_particle
{
	NAME fx_particle;
	INCLUDE Obase;

	//Basic Tab
	GROUP ID_OBJECTPROPERTIES
	{			
		DEFAULT 1;
		LONG DPARTICLE_MODE
		{
			CYCLE
			{
				DPARTICLE_MODE_POINTS;
				DPARTICLE_MODE_POLYMID;
				DPARTICLE_MODE_POLYGON;
				DPARTICLE_MODE_SPLINE;
				DPARTICLE_MODE_SPAWN;
				DPARTICLE_MODE_BRUSH;
			}
		}
		LINK DPARTICLE_LINK {ACCEPT{Obase;}; }
		LINK DPARTICLE_SOLVER {ACCEPT{Obase;}; }
		
		LONG DPARTICLE_INSTANCE 
		{
			CYCLE
			{
				DPARTICLE_INSTANCE_ORIG;
				DPARTICLE_INSTANCE_INSTANCE;
				DPARTICLE_INSTANCE_RENDERINSTANCE;
			}
		}
		LONG DPARTICLE_DIRECTION
		{
			CYCLE
			{
				DPARTICLE_DIR_NORMAL;
				DPARTICLE_DIR_X;
				DPARTICLE_DIR_Y;
				DPARTICLE_DIR_Z;
				DPARTICLE_DIR_SPHERE;
				DPARTICLE_DIR_CYLINDER;
				DPARTICLE_DIR_OBJECT;
			}
		}
		LINK DPARTICLE_OBJECT {ACCEPT{Obase;}; HIDDEN;}
		LONG DPARTICLE_POLYSEED {}

		SEPARATOR {LINE;}
		
		BOOL DPARTICLE_SHOOT {}
		LONG DPARTICLE_MAXCOUNT {MIN 0; MAX 10000000; }
		GROUP
		{
			COLUMNS 2;
			LONG DPARTICLE_COUNT {MIN 0; MAX 10000000; }			
			REAL DPARTICLE_COUNT_VAR {MIN 0; MAX 100; UNIT PERCENT;}

			LONG DPARTICLE_LIFETIME {MIN 0;}
			REAL DPARTICLE_LIFETIME_VAR {MIN 0; MAX 100; UNIT PERCENT;}
			
			REAL DPARTICLE_SPEED {UNIT METER;}
			REAL DPARTICLE_SPEED_VAR {MIN 0; MAX 100; UNIT PERCENT;}
					
			REAL DPARTICLE_GLBSCALE {MIN 0;}
			REAL DPARTICLE_SCALE_VAR {MIN 0; MAX 100; UNIT PERCENT;}

			BOOL DPARTICLE_TANGENTIAL {}
			REAL DPARTICLE_VEL_SCALE {MIN 0; MAX 1000; UNIT PERCENT;}
		}
		GROUP DPARTICLE_SETTINGS_BRUSH
		{
			DEFAULT 1; HIDDEN;
			GROUP
			{
				COLUMNS 2;
				BOOL DPARTICLE_DRAW_BRUSHDATA {}
				COLOR DPARTICLE_BRUSHDATA_COLOR {}
			}
		}
		GROUP DPARTICLE_SUB_SPLINE
		{
			HIDDEN;
			DEFAULT 1;
			//Spline
			GROUP
			{
				COLUMNS 2;
				LONG DPARTICLE_S_TYPE
				{
					CYCLE
					{
						DPARTICLE_S_POINTS;
						DPARTICLE_S_POINTSRND;
						DPARTICLE_S_UNI;
						DPARTICLE_S_UNIRND;
						DPARTICLE_S_RANDOM;
					}
				}
				LONG DPARTICLE_S_UNICOUNT {MIN 1; MAX 100000;}
			}
			LINK DPARTICLE_POINTSEL {ACCEPT{Tpointselection;};}

			SEPARATOR {LINE;}
			
			GROUP
			{
				COLUMNS 2;
				REAL DPARTICLE_S_TANROT {MIN -360000; MAX 360000; UNIT DEGREE;}
				BOOL DPARTICLE_S_TANROT_UG {}
			}
			SPLINE DPARTICLE_TANROT_GRAPH
			{ 
				SHOWGRID_H; 
				GRIDSIZE_V 100;
				GRIDSIZE_H 10; 
													  
				MINSIZE_H 80;
				MINSIZE_V 50; 
													  
				X_MIN 0; 
				X_MAX 1; 
								  
				Y_MIN 0; 
				Y_MAX 1; 
								  
				X_STEPS 0.01; 
				Y_STEPS 0.01;
			}
			GROUP
			{
				COLUMNS 2;
				REAL DPARTICLE_S_ATANROT {MIN -360000; MAX 360000; UNIT DEGREE;}
				BOOL DPARTICLE_S_ATANROT_UG {}
			}
			SPLINE DPARTICLE_S_ATANROT_GRAPH
			{ 
				SHOWGRID_H; 
				GRIDSIZE_V 100;
				GRIDSIZE_H 10; 
													  
				MINSIZE_H 80;
				MINSIZE_V 50; 
													  
				X_MIN 0; 
				X_MAX 1; 
								  
				Y_MIN 0; 
				Y_MAX 1; 
								  
				X_STEPS 0.01; 
				Y_STEPS 0.01;
			}
			

			SEPARATOR {LINE;}

			LONG DPARTICLE_S_LOOPTYPE
			{
				CYCLE
				{
					DPARTICLE_S_LOOP_NONE;
					DPARTICLE_S_LOOP_DEFAULT;
					DPARTICLE_S_LOOP_BAF;
				}
			}
			REAL DPARTICLE_S_LOOPMIN {MINSLIDER 0; MAXSLIDER 100; UNIT PERCENT; CUSTOMGUI REALSLIDER;}
			REAL DPARTICLE_S_LOOPMAX {MINSLIDER 0; MAXSLIDER 100; UNIT PERCENT; CUSTOMGUI REALSLIDER;}
			
			SPLINE DPARTICLE_S_TIMESHIFT
			{ 
				SHOWGRID_H; 
				GRIDSIZE_V 100;
				GRIDSIZE_H 10; 
												  
				MINSIZE_H 80;
				MINSIZE_V 50; 
												  
				X_MIN 0; 
				X_MAX 1; 
								  
				Y_MIN 0; 
				Y_MAX 1; 
								  
				X_STEPS 0.01; 
				Y_STEPS 0.01; 
			}
						
		}

		GROUP DPARTICLE_SUB_POLYGON
		{
			DEFAULT 1;
			//Polygon & Point
			SHADERLINK DPARTICLE_EMISSIONSHADER {}
			REAL DPARTICLE_EMISSIONSHADER_DELTA_A {MIN 0; MAX 100; UNIT PERCENT;}
			REAL DPARTICLE_EMISSIONSHADER_DELTA_B {MIN 0; MAX 100; UNIT PERCENT;}
			LINK DPARTICLE_POLYGONSEL {ACCEPT{Tpolygonselection;Tpointselection;};}
		}
		SEPARATOR {LINE;}

		BOOL DPARTICLE_RENDERONLY {}
		
		BOOL DPARTICLE_DRAW {}
		COLOR DPARTICLE_PARTICLE_COLOR {}
		
		SEPARATOR {LINE;}	
	
		BOOL DPARTICLE_DYN_AUTOTIME {}
		GROUP
		{
			COLUMNS 2;
			LONG DPARTICLE_DYN_FROM {MIN 0; }
			LONG DPARTICLE_DYN_TO {MIN 1;}
		}
		//SEPARATOR {LINE;}
		//BUTTON DPARTICLE_SETINIT {}
	}
	GROUP DPARTICLE_ATTRIBUTES
	{
		REAL DPARTICLE_PARTICLE_RAD {MIN 0; STEP 0.5;}
		REAL DPARTICLE_DAMPING {MIN 0; MAX 100; UNIT PERCENT;}
		REAL DPARTICLE_MASS {MIN 0.01; MAX 10000;}
		REAL DPARTICLE_GRAVITY {}
		
		GROUP DPARTICLE_FORCES
		{			
			DEFAULT 1;
			REAL DPARTICLE_IMPACT { MIN 0; MAX 100; UNIT PERCENT;}
			IN_EXCLUDE  DPARTICLE_FORCES_INCLUDE
			{
				NUM_FLAGS 0; INIT_STATE 0; SEND_SELCHNGMSG 1;
				ACCEPT { Obase; };
			}
		}
		GROUP DPARTICLE_TARGET
		{			
			DEFAULT 1;
			HIDDEN;
			LINK DPARTICLE_TARGETING_SP {ACCEPT{fx_particle;}; }
			LONG DPARTICLE_TARGETING_LENGTH { MIN 1; }
			LONG DPARTICLE_TARGETING_PRIORITY_OFFSET { MIN 1; }

			SEPARATOR {LINE;}
			
			SPLINE DPARTICLE_TARGETING_POS_X
			{ 
				SHOWGRID_H; GRIDSIZE_V 100; GRIDSIZE_H 10; MINSIZE_H 80;MINSIZE_V 50; 
				X_MIN 0; X_MAX 1; Y_MIN 0; Y_MAX 1; X_STEPS 0.01; Y_STEPS 0.01; 
			}
			SPLINE DPARTICLE_TARGETING_POS_Y
			{ 
				SHOWGRID_H; GRIDSIZE_V 100; GRIDSIZE_H 10; MINSIZE_H 80;MINSIZE_V 50; 
				X_MIN 0; X_MAX 1; Y_MIN 0; Y_MAX 1; X_STEPS 0.01; Y_STEPS 0.01; 
			}
			SPLINE DPARTICLE_TARGETING_POS_Z
			{ 
				SHOWGRID_H; GRIDSIZE_V 100; GRIDSIZE_H 10; MINSIZE_H 80;MINSIZE_V 50; 
				X_MIN 0; X_MAX 1; Y_MIN 0; Y_MAX 1; X_STEPS 0.01; Y_STEPS 0.01; 
			}

			SEPARATOR {LINE;}
			
			REAL DPARTICLE_TARGETING_RAD {MIN 0; STEP 0.1;}
			SPLINE DPARTICLE_TARGETING_RADTIMER
			{ 
				SHOWGRID_H; GRIDSIZE_V 100; GRIDSIZE_H 10; MINSIZE_H 80;MINSIZE_V 50; 
				X_MIN 0; X_MAX 1; Y_MIN 0; Y_MAX 1; X_STEPS 0.01; Y_STEPS 0.01; 
			}
		}
		GROUP DPARTICLE_COLLISION_G
		{				
			DEFAULT 1;
			BOOL DPARTICLE_USECOLLISION {}
			BOOL DPARTICLE_USEBRANCHCOLL {}
			BOOL DPARTICLE_USESPAWN {}

			SEPARATOR {LINE;}

			REAL DPARTICLE_PARTICLE_FRICTION {MIN 0; MAX 100; UNIT PERCENT;}
			REAL DPARTICLE_MASS_DEPENDANCY {MIN 0; MAX 100; UNIT PERCENT;}
			REAL DPARTICLE_LOOSE_GLUE {MIN 0; MAX 1000; UNIT PERCENT;}	

			SEPARATOR {LINE;}

			LONG DPARTICLE_ROTCHANGE_STEPS {MIN 0; MAX 30;}	
		}
	}
	GROUP DPARTICLE_AGEG
	{
		BOOL DPARTICLE_USEAGE {}

		SEPARATOR{LINE;}

		VECTOR DPARTICLE_SCALE	{MIN 0 0 0;}
		GRADIENT DPARTICLE_SCALE_AGEX {ANIM ON;}
		GRADIENT DPARTICLE_SCALE_AGEY {ANIM ON;}
		GRADIENT DPARTICLE_SCALE_AGEZ {ANIM ON;}
		
		SEPARATOR{LINE;}

		VECTOR DPARTICLE_BILLOW	{MIN -360 -360 -360; MAX 360 360 360; UNIT DEGREE;}
		GRADIENT DPARTICLE_BILLOW_AGEX {ALPHA;ANIM ON;}
		GRADIENT DPARTICLE_BILLOW_AGEY {ANIM ON;}
		GRADIENT DPARTICLE_BILLOW_AGEZ {ANIM ON;}

		SEPARATOR{LINE;}

		STRING DPARTICLE_IDMUL {}
	}
	GROUP DPARTICLE_SUB_CACHE
		{
			LONG DPARTICLE_CACHEMODE
			{
				CYCLE
				{
				DPARTICLE_CACHEMODE_OFF;
				DPARTICLE_CACHEMODE_LOAD;
				DPARTICLE_CACHEMODE_SAVE;
				}
			}
			SEPARATOR {LINE;}
			BUTTON DPARTICLE_CACHE_FOLDER {}
			STRING DPARTICLE_CACHE_PATH {}
			STRING DPARTICLE_CACHENAME {}
			BUTTON DPARTICLE_CACHE_CLEAR {}
			
			SEPARATOR{LINE;}

			GROUP DPARTICLE_SUB_CACHE_LOAD
			{
				DEFAULT 1;
				BOOL DPARTICLE_CACHE_LOAD_RENDER {ANIM OFF;}
				BOOL DPARTICLE_CACHE_LOAD_RAM {ANIM OFF;}
				LONG DPARTICLE_CACHE_LOAD_FRAME {MIN -1; }			
				STRING DPARTICLE_CACHE_LOAD_INFO { CUSTOMGUI MULTISTRING; }
			}
			GROUP DPARTICLE_SUB_CACHE_SAVE
			{
				DEFAULT 1;
				LONG DPARTICLE_CACHE_SAVEMODE
				{
					CYCLE
					{
					DPARTICLE_CACHE_SAVEMODE_RAM;
					DPARTICLE_CACHE_SAVEMODE_DISK;
					DPARTICLE_CACHE_SAVEMODE_DISKRENDER;
					}
				}
				BOOL DPARTICLE_CACHE_SAVE_COMPRESS {ANIM OFF; HIDDEN;}
			}
		}
}